package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{ResourceId, Nonce}
import scala.jdk.CollectionConverters.*
final case class CreateReusableDelegationSetRequest(
    callerReference: Nonce,
    hostedZoneId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest = {
    import CreateReusableDelegationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest
      .builder()
      .callerReference(Nonce.unwrap(callerReference): java.lang.String)
      .optionallyWith(
        hostedZoneId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.hostedZoneId)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.CreateReusableDelegationSetRequest.ReadOnly =
    zio.aws.route53.model.CreateReusableDelegationSetRequest
      .wrap(buildAwsValue())
}
object CreateReusableDelegationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateReusableDelegationSetRequest =
      zio.aws.route53.model.CreateReusableDelegationSetRequest(
        callerReference,
        hostedZoneId.map(value => value)
      )
    def callerReference: Nonce
    def hostedZoneId: Option[ResourceId]
    def getCallerReference: ZIO[Any, Nothing, Nonce] =
      ZIO.succeed(callerReference)
    def getHostedZoneId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest
  ) extends zio.aws.route53.model.CreateReusableDelegationSetRequest.ReadOnly {
    override val callerReference: Nonce =
      zio.aws.route53.model.primitives.Nonce(impl.callerReference())
    override val hostedZoneId: Option[ResourceId] = scala
      .Option(impl.hostedZoneId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest
  ): zio.aws.route53.model.CreateReusableDelegationSetRequest.ReadOnly =
    new Wrapper(impl)
}
