package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceURI
import scala.jdk.CollectionConverters.*
final case class CreateTrafficPolicyInstanceResponse(
    trafficPolicyInstance: zio.aws.route53.model.TrafficPolicyInstance,
    location: ResourceURI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse = {
    import CreateTrafficPolicyInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse
      .builder()
      .trafficPolicyInstance(trafficPolicyInstance.buildAwsValue())
      .location(ResourceURI.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.CreateTrafficPolicyInstanceResponse.ReadOnly =
    zio.aws.route53.model.CreateTrafficPolicyInstanceResponse
      .wrap(buildAwsValue())
}
object CreateTrafficPolicyInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateTrafficPolicyInstanceResponse =
      zio.aws.route53.model.CreateTrafficPolicyInstanceResponse(
        trafficPolicyInstance.asEditable,
        location
      )
    def trafficPolicyInstance
        : zio.aws.route53.model.TrafficPolicyInstance.ReadOnly
    def location: ResourceURI
    def getTrafficPolicyInstance: ZIO[
      Any,
      Nothing,
      zio.aws.route53.model.TrafficPolicyInstance.ReadOnly
    ] = ZIO.succeed(trafficPolicyInstance)
    def getLocation: ZIO[Any, Nothing, ResourceURI] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse
  ) extends zio.aws.route53.model.CreateTrafficPolicyInstanceResponse.ReadOnly {
    override val trafficPolicyInstance
        : zio.aws.route53.model.TrafficPolicyInstance.ReadOnly =
      zio.aws.route53.model.TrafficPolicyInstance
        .wrap(impl.trafficPolicyInstance())
    override val location: ResourceURI =
      zio.aws.route53.model.primitives.ResourceURI(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse
  ): zio.aws.route53.model.CreateTrafficPolicyInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
