package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  TrafficPolicyComment,
  TrafficPolicyDocument,
  TrafficPolicyName
}
import scala.jdk.CollectionConverters.*
final case class CreateTrafficPolicyRequest(
    name: TrafficPolicyName,
    document: TrafficPolicyDocument,
    comment: Option[TrafficPolicyComment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest = {
    import CreateTrafficPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest
      .builder()
      .name(TrafficPolicyName.unwrap(name): java.lang.String)
      .document(TrafficPolicyDocument.unwrap(document): java.lang.String)
      .optionallyWith(
        comment.map(value =>
          TrafficPolicyComment.unwrap(value): java.lang.String
        )
      )(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateTrafficPolicyRequest.ReadOnly =
    zio.aws.route53.model.CreateTrafficPolicyRequest.wrap(buildAwsValue())
}
object CreateTrafficPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateTrafficPolicyRequest =
      zio.aws.route53.model
        .CreateTrafficPolicyRequest(name, document, comment.map(value => value))
    def name: TrafficPolicyName
    def document: TrafficPolicyDocument
    def comment: Option[TrafficPolicyComment]
    def getName: ZIO[Any, Nothing, TrafficPolicyName] = ZIO.succeed(name)
    def getDocument: ZIO[Any, Nothing, TrafficPolicyDocument] =
      ZIO.succeed(document)
    def getComment: ZIO[Any, AwsError, TrafficPolicyComment] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest
  ) extends zio.aws.route53.model.CreateTrafficPolicyRequest.ReadOnly {
    override val name: TrafficPolicyName =
      zio.aws.route53.model.primitives.TrafficPolicyName(impl.name())
    override val document: TrafficPolicyDocument =
      zio.aws.route53.model.primitives.TrafficPolicyDocument(impl.document())
    override val comment: Option[TrafficPolicyComment] = scala
      .Option(impl.comment())
      .map(value =>
        zio.aws.route53.model.primitives.TrafficPolicyComment(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest
  ): zio.aws.route53.model.CreateTrafficPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
