package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  TrafficPolicyComment,
  TrafficPolicyDocument,
  TrafficPolicyId
}
import scala.jdk.CollectionConverters.*
final case class CreateTrafficPolicyVersionRequest(
    id: TrafficPolicyId,
    document: TrafficPolicyDocument,
    comment: Option[TrafficPolicyComment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest = {
    import CreateTrafficPolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest
      .builder()
      .id(TrafficPolicyId.unwrap(id): java.lang.String)
      .document(TrafficPolicyDocument.unwrap(document): java.lang.String)
      .optionallyWith(
        comment.map(value =>
          TrafficPolicyComment.unwrap(value): java.lang.String
        )
      )(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.CreateTrafficPolicyVersionRequest.ReadOnly =
    zio.aws.route53.model.CreateTrafficPolicyVersionRequest
      .wrap(buildAwsValue())
}
object CreateTrafficPolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateTrafficPolicyVersionRequest =
      zio.aws.route53.model.CreateTrafficPolicyVersionRequest(
        id,
        document,
        comment.map(value => value)
      )
    def id: TrafficPolicyId
    def document: TrafficPolicyDocument
    def comment: Option[TrafficPolicyComment]
    def getId: ZIO[Any, Nothing, TrafficPolicyId] = ZIO.succeed(id)
    def getDocument: ZIO[Any, Nothing, TrafficPolicyDocument] =
      ZIO.succeed(document)
    def getComment: ZIO[Any, AwsError, TrafficPolicyComment] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest
  ) extends zio.aws.route53.model.CreateTrafficPolicyVersionRequest.ReadOnly {
    override val id: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.id())
    override val document: TrafficPolicyDocument =
      zio.aws.route53.model.primitives.TrafficPolicyDocument(impl.document())
    override val comment: Option[TrafficPolicyComment] = scala
      .Option(impl.comment())
      .map(value =>
        zio.aws.route53.model.primitives.TrafficPolicyComment(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest
  ): zio.aws.route53.model.CreateTrafficPolicyVersionRequest.ReadOnly =
    new Wrapper(impl)
}
