package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{DNSName, Nonce, ResourceId}
import scala.jdk.CollectionConverters.*
final case class DelegationSet(
    id: Option[ResourceId] = None,
    callerReference: Option[Nonce] = None,
    nameServers: Iterable[DNSName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DelegationSet = {
    import DelegationSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DelegationSet
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        callerReference.map(value => Nonce.unwrap(value): java.lang.String)
      )(_.callerReference)
      .nameServers(nameServers.map { item =>
        DNSName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.DelegationSet.ReadOnly =
    zio.aws.route53.model.DelegationSet.wrap(buildAwsValue())
}
object DelegationSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DelegationSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DelegationSet =
      zio.aws.route53.model.DelegationSet(
        id.map(value => value),
        callerReference.map(value => value),
        nameServers
      )
    def id: Option[ResourceId]
    def callerReference: Option[Nonce]
    def nameServers: List[DNSName]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getCallerReference: ZIO[Any, AwsError, Nonce] =
      AwsError.unwrapOptionField("callerReference", callerReference)
    def getNameServers: ZIO[Any, Nothing, List[DNSName]] =
      ZIO.succeed(nameServers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DelegationSet
  ) extends zio.aws.route53.model.DelegationSet.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val callerReference: Option[Nonce] = scala
      .Option(impl.callerReference())
      .map(value => zio.aws.route53.model.primitives.Nonce(value))
    override val nameServers: List[DNSName] = impl
      .nameServers()
      .asScala
      .map { item =>
        zio.aws.route53.model.primitives.DNSName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DelegationSet
  ): zio.aws.route53.model.DelegationSet.ReadOnly = new Wrapper(impl)
}
