package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{SigningKeyName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class DeleteKeySigningKeyRequest(
    hostedZoneId: ResourceId,
    name: SigningKeyName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyRequest = {
    import DeleteKeySigningKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .name(SigningKeyName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.DeleteKeySigningKeyRequest.ReadOnly =
    zio.aws.route53.model.DeleteKeySigningKeyRequest.wrap(buildAwsValue())
}
object DeleteKeySigningKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DeleteKeySigningKeyRequest =
      zio.aws.route53.model.DeleteKeySigningKeyRequest(hostedZoneId, name)
    def hostedZoneId: ResourceId
    def name: SigningKeyName
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getName: ZIO[Any, Nothing, SigningKeyName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyRequest
  ) extends zio.aws.route53.model.DeleteKeySigningKeyRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val name: SigningKeyName =
      zio.aws.route53.model.primitives.SigningKeyName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyRequest
  ): zio.aws.route53.model.DeleteKeySigningKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
