package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class DeleteReusableDelegationSetRequest(id: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest = {
    import DeleteReusableDelegationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.DeleteReusableDelegationSetRequest.ReadOnly =
    zio.aws.route53.model.DeleteReusableDelegationSetRequest
      .wrap(buildAwsValue())
}
object DeleteReusableDelegationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DeleteReusableDelegationSetRequest =
      zio.aws.route53.model.DeleteReusableDelegationSetRequest(id)
    def id: ResourceId
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest
  ) extends zio.aws.route53.model.DeleteReusableDelegationSetRequest.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest
  ): zio.aws.route53.model.DeleteReusableDelegationSetRequest.ReadOnly =
    new Wrapper(impl)
}
