package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{TrafficPolicyVersion, TrafficPolicyId}
import scala.jdk.CollectionConverters.*
final case class DeleteTrafficPolicyRequest(
    id: TrafficPolicyId,
    version: TrafficPolicyVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest = {
    import DeleteTrafficPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest
      .builder()
      .id(TrafficPolicyId.unwrap(id): java.lang.String)
      .version(TrafficPolicyVersion.unwrap(version): Integer)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.DeleteTrafficPolicyRequest.ReadOnly =
    zio.aws.route53.model.DeleteTrafficPolicyRequest.wrap(buildAwsValue())
}
object DeleteTrafficPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DeleteTrafficPolicyRequest =
      zio.aws.route53.model.DeleteTrafficPolicyRequest(id, version)
    def id: TrafficPolicyId
    def version: TrafficPolicyVersion
    def getId: ZIO[Any, Nothing, TrafficPolicyId] = ZIO.succeed(id)
    def getVersion: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest
  ) extends zio.aws.route53.model.DeleteTrafficPolicyRequest.ReadOnly {
    override val id: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.id())
    override val version: TrafficPolicyVersion =
      zio.aws.route53.model.primitives.TrafficPolicyVersion(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest
  ): zio.aws.route53.model.DeleteTrafficPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
