package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class DeleteVpcAssociationAuthorizationRequest(
    hostedZoneId: ResourceId,
    vpc: zio.aws.route53.model.VPC
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest = {
    import DeleteVpcAssociationAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .vpc(vpc.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.DeleteVpcAssociationAuthorizationRequest.ReadOnly =
    zio.aws.route53.model.DeleteVpcAssociationAuthorizationRequest
      .wrap(buildAwsValue())
}
object DeleteVpcAssociationAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53.model.DeleteVpcAssociationAuthorizationRequest =
      zio.aws.route53.model
        .DeleteVpcAssociationAuthorizationRequest(hostedZoneId, vpc.asEditable)
    def hostedZoneId: ResourceId
    def vpc: zio.aws.route53.model.VPC.ReadOnly
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getVpc: ZIO[Any, Nothing, zio.aws.route53.model.VPC.ReadOnly] =
      ZIO.succeed(vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest
  ) extends zio.aws.route53.model.DeleteVpcAssociationAuthorizationRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val vpc: zio.aws.route53.model.VPC.ReadOnly =
      zio.aws.route53.model.VPC.wrap(impl.vpc())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest
  ): zio.aws.route53.model.DeleteVpcAssociationAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
