package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{DisassociateVPCComment, ResourceId}
import scala.jdk.CollectionConverters.*
final case class DisassociateVpcFromHostedZoneRequest(
    hostedZoneId: ResourceId,
    vpc: zio.aws.route53.model.VPC,
    comment: Option[DisassociateVPCComment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest = {
    import DisassociateVpcFromHostedZoneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .vpc(vpc.buildAwsValue())
      .optionallyWith(
        comment.map(value =>
          DisassociateVPCComment.unwrap(value): java.lang.String
        )
      )(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.DisassociateVpcFromHostedZoneRequest.ReadOnly =
    zio.aws.route53.model.DisassociateVpcFromHostedZoneRequest
      .wrap(buildAwsValue())
}
object DisassociateVpcFromHostedZoneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DisassociateVpcFromHostedZoneRequest =
      zio.aws.route53.model.DisassociateVpcFromHostedZoneRequest(
        hostedZoneId,
        vpc.asEditable,
        comment.map(value => value)
      )
    def hostedZoneId: ResourceId
    def vpc: zio.aws.route53.model.VPC.ReadOnly
    def comment: Option[DisassociateVPCComment]
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getVpc: ZIO[Any, Nothing, zio.aws.route53.model.VPC.ReadOnly] =
      ZIO.succeed(vpc)
    def getComment: ZIO[Any, AwsError, DisassociateVPCComment] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest
  ) extends zio.aws.route53.model.DisassociateVpcFromHostedZoneRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val vpc: zio.aws.route53.model.VPC.ReadOnly =
      zio.aws.route53.model.VPC.wrap(impl.vpc())
    override val comment: Option[DisassociateVPCComment] = scala
      .Option(impl.comment())
      .map(value =>
        zio.aws.route53.model.primitives.DisassociateVPCComment(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest
  ): zio.aws.route53.model.DisassociateVpcFromHostedZoneRequest.ReadOnly =
    new Wrapper(impl)
}
