package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  GeoLocationSubdivisionName,
  GeoLocationCountryCode,
  GeoLocationContinentName,
  GeoLocationContinentCode,
  GeoLocationSubdivisionCode,
  GeoLocationCountryName
}
import scala.jdk.CollectionConverters.*
final case class GeoLocationDetails(
    continentCode: Option[GeoLocationContinentCode] = None,
    continentName: Option[GeoLocationContinentName] = None,
    countryCode: Option[GeoLocationCountryCode] = None,
    countryName: Option[GeoLocationCountryName] = None,
    subdivisionCode: Option[GeoLocationSubdivisionCode] = None,
    subdivisionName: Option[GeoLocationSubdivisionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GeoLocationDetails = {
    import GeoLocationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GeoLocationDetails
      .builder()
      .optionallyWith(
        continentCode.map(value =>
          GeoLocationContinentCode.unwrap(value): java.lang.String
        )
      )(_.continentCode)
      .optionallyWith(
        continentName.map(value =>
          GeoLocationContinentName.unwrap(value): java.lang.String
        )
      )(_.continentName)
      .optionallyWith(
        countryCode.map(value =>
          GeoLocationCountryCode.unwrap(value): java.lang.String
        )
      )(_.countryCode)
      .optionallyWith(
        countryName.map(value =>
          GeoLocationCountryName.unwrap(value): java.lang.String
        )
      )(_.countryName)
      .optionallyWith(
        subdivisionCode.map(value =>
          GeoLocationSubdivisionCode.unwrap(value): java.lang.String
        )
      )(_.subdivisionCode)
      .optionallyWith(
        subdivisionName.map(value =>
          GeoLocationSubdivisionName.unwrap(value): java.lang.String
        )
      )(_.subdivisionName)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GeoLocationDetails.ReadOnly =
    zio.aws.route53.model.GeoLocationDetails.wrap(buildAwsValue())
}
object GeoLocationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GeoLocationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GeoLocationDetails =
      zio.aws.route53.model.GeoLocationDetails(
        continentCode.map(value => value),
        continentName.map(value => value),
        countryCode.map(value => value),
        countryName.map(value => value),
        subdivisionCode.map(value => value),
        subdivisionName.map(value => value)
      )
    def continentCode: Option[GeoLocationContinentCode]
    def continentName: Option[GeoLocationContinentName]
    def countryCode: Option[GeoLocationCountryCode]
    def countryName: Option[GeoLocationCountryName]
    def subdivisionCode: Option[GeoLocationSubdivisionCode]
    def subdivisionName: Option[GeoLocationSubdivisionName]
    def getContinentCode: ZIO[Any, AwsError, GeoLocationContinentCode] =
      AwsError.unwrapOptionField("continentCode", continentCode)
    def getContinentName: ZIO[Any, AwsError, GeoLocationContinentName] =
      AwsError.unwrapOptionField("continentName", continentName)
    def getCountryCode: ZIO[Any, AwsError, GeoLocationCountryCode] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getCountryName: ZIO[Any, AwsError, GeoLocationCountryName] =
      AwsError.unwrapOptionField("countryName", countryName)
    def getSubdivisionCode: ZIO[Any, AwsError, GeoLocationSubdivisionCode] =
      AwsError.unwrapOptionField("subdivisionCode", subdivisionCode)
    def getSubdivisionName: ZIO[Any, AwsError, GeoLocationSubdivisionName] =
      AwsError.unwrapOptionField("subdivisionName", subdivisionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GeoLocationDetails
  ) extends zio.aws.route53.model.GeoLocationDetails.ReadOnly {
    override val continentCode: Option[GeoLocationContinentCode] = scala
      .Option(impl.continentCode())
      .map(value =>
        zio.aws.route53.model.primitives.GeoLocationContinentCode(value)
      )
    override val continentName: Option[GeoLocationContinentName] = scala
      .Option(impl.continentName())
      .map(value =>
        zio.aws.route53.model.primitives.GeoLocationContinentName(value)
      )
    override val countryCode: Option[GeoLocationCountryCode] = scala
      .Option(impl.countryCode())
      .map(value =>
        zio.aws.route53.model.primitives.GeoLocationCountryCode(value)
      )
    override val countryName: Option[GeoLocationCountryName] = scala
      .Option(impl.countryName())
      .map(value =>
        zio.aws.route53.model.primitives.GeoLocationCountryName(value)
      )
    override val subdivisionCode: Option[GeoLocationSubdivisionCode] = scala
      .Option(impl.subdivisionCode())
      .map(value =>
        zio.aws.route53.model.primitives.GeoLocationSubdivisionCode(value)
      )
    override val subdivisionName: Option[GeoLocationSubdivisionName] = scala
      .Option(impl.subdivisionName())
      .map(value =>
        zio.aws.route53.model.primitives.GeoLocationSubdivisionName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GeoLocationDetails
  ): zio.aws.route53.model.GeoLocationDetails.ReadOnly = new Wrapper(impl)
}
