package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.UsageCount
import scala.jdk.CollectionConverters.*
final case class GetAccountLimitResponse(
    limit: zio.aws.route53.model.AccountLimit,
    count: UsageCount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetAccountLimitResponse = {
    import GetAccountLimitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetAccountLimitResponse
      .builder()
      .limit(limit.buildAwsValue())
      .count(UsageCount.unwrap(count): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetAccountLimitResponse.ReadOnly =
    zio.aws.route53.model.GetAccountLimitResponse.wrap(buildAwsValue())
}
object GetAccountLimitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetAccountLimitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetAccountLimitResponse =
      zio.aws.route53.model.GetAccountLimitResponse(limit.asEditable, count)
    def limit: zio.aws.route53.model.AccountLimit.ReadOnly
    def count: UsageCount
    def getLimit
        : ZIO[Any, Nothing, zio.aws.route53.model.AccountLimit.ReadOnly] =
      ZIO.succeed(limit)
    def getCount: ZIO[Any, Nothing, UsageCount] = ZIO.succeed(count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetAccountLimitResponse
  ) extends zio.aws.route53.model.GetAccountLimitResponse.ReadOnly {
    override val limit: zio.aws.route53.model.AccountLimit.ReadOnly =
      zio.aws.route53.model.AccountLimit.wrap(impl.limit())
    override val count: UsageCount =
      zio.aws.route53.model.primitives.UsageCount(impl.count())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetAccountLimitResponse
  ): zio.aws.route53.model.GetAccountLimitResponse.ReadOnly = new Wrapper(impl)
}
