package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.IPAddressCidr
import scala.jdk.CollectionConverters.*
final case class GetCheckerIpRangesResponse(
    checkerIpRanges: Iterable[IPAddressCidr]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse = {
    import GetCheckerIpRangesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse
      .builder()
      .checkerIpRanges(checkerIpRanges.map { item =>
        IPAddressCidr.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetCheckerIpRangesResponse.ReadOnly =
    zio.aws.route53.model.GetCheckerIpRangesResponse.wrap(buildAwsValue())
}
object GetCheckerIpRangesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetCheckerIpRangesResponse =
      zio.aws.route53.model.GetCheckerIpRangesResponse(checkerIpRanges)
    def checkerIpRanges: List[IPAddressCidr]
    def getCheckerIpRanges: ZIO[Any, Nothing, List[IPAddressCidr]] =
      ZIO.succeed(checkerIpRanges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse
  ) extends zio.aws.route53.model.GetCheckerIpRangesResponse.ReadOnly {
    override val checkerIpRanges: List[IPAddressCidr] = impl
      .checkerIpRanges()
      .asScala
      .map { item =>
        zio.aws.route53.model.primitives.IPAddressCidr(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse
  ): zio.aws.route53.model.GetCheckerIpRangesResponse.ReadOnly = new Wrapper(
    impl
  )
}
