package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetDnssecRequest(hostedZoneId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetDnssecRequest = {
    import GetDnssecRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetDnssecRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetDnssecRequest.ReadOnly =
    zio.aws.route53.model.GetDnssecRequest.wrap(buildAwsValue())
}
object GetDnssecRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetDnssecRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetDnssecRequest =
      zio.aws.route53.model.GetDnssecRequest(hostedZoneId)
    def hostedZoneId: ResourceId
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetDnssecRequest
  ) extends zio.aws.route53.model.GetDnssecRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetDnssecRequest
  ): zio.aws.route53.model.GetDnssecRequest.ReadOnly = new Wrapper(impl)
}
