package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDnssecResponse(
    status: zio.aws.route53.model.DNSSECStatus,
    keySigningKeys: Iterable[zio.aws.route53.model.KeySigningKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetDnssecResponse = {
    import GetDnssecResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetDnssecResponse
      .builder()
      .status(status.buildAwsValue())
      .keySigningKeys(keySigningKeys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetDnssecResponse.ReadOnly =
    zio.aws.route53.model.GetDnssecResponse.wrap(buildAwsValue())
}
object GetDnssecResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetDnssecResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetDnssecResponse =
      zio.aws.route53.model.GetDnssecResponse(
        status.asEditable,
        keySigningKeys.map { item =>
          item.asEditable
        }
      )
    def status: zio.aws.route53.model.DNSSECStatus.ReadOnly
    def keySigningKeys: List[zio.aws.route53.model.KeySigningKey.ReadOnly]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.route53.model.DNSSECStatus.ReadOnly] =
      ZIO.succeed(status)
    def getKeySigningKeys: ZIO[Any, Nothing, List[
      zio.aws.route53.model.KeySigningKey.ReadOnly
    ]] = ZIO.succeed(keySigningKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetDnssecResponse
  ) extends zio.aws.route53.model.GetDnssecResponse.ReadOnly {
    override val status: zio.aws.route53.model.DNSSECStatus.ReadOnly =
      zio.aws.route53.model.DNSSECStatus.wrap(impl.status())
    override val keySigningKeys
        : List[zio.aws.route53.model.KeySigningKey.ReadOnly] = impl
      .keySigningKeys()
      .asScala
      .map { item =>
        zio.aws.route53.model.KeySigningKey.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetDnssecResponse
  ): zio.aws.route53.model.GetDnssecResponse.ReadOnly = new Wrapper(impl)
}
