package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.HealthCheckId
import scala.jdk.CollectionConverters.*
final case class GetHealthCheckLastFailureReasonRequest(
    healthCheckId: HealthCheckId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest = {
    import GetHealthCheckLastFailureReasonRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest
      .builder()
      .healthCheckId(HealthCheckId.unwrap(healthCheckId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.GetHealthCheckLastFailureReasonRequest.ReadOnly =
    zio.aws.route53.model.GetHealthCheckLastFailureReasonRequest
      .wrap(buildAwsValue())
}
object GetHealthCheckLastFailureReasonRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53.model.GetHealthCheckLastFailureReasonRequest =
      zio.aws.route53.model
        .GetHealthCheckLastFailureReasonRequest(healthCheckId)
    def healthCheckId: HealthCheckId
    def getHealthCheckId: ZIO[Any, Nothing, HealthCheckId] =
      ZIO.succeed(healthCheckId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest
  ) extends zio.aws.route53.model.GetHealthCheckLastFailureReasonRequest.ReadOnly {
    override val healthCheckId: HealthCheckId =
      zio.aws.route53.model.primitives.HealthCheckId(impl.healthCheckId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest
  ): zio.aws.route53.model.GetHealthCheckLastFailureReasonRequest.ReadOnly =
    new Wrapper(impl)
}
