package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetHealthCheckStatusResponse(
    healthCheckObservations: Iterable[
      zio.aws.route53.model.HealthCheckObservation
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse = {
    import GetHealthCheckStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse
      .builder()
      .healthCheckObservations(healthCheckObservations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHealthCheckStatusResponse.ReadOnly =
    zio.aws.route53.model.GetHealthCheckStatusResponse.wrap(buildAwsValue())
}
object GetHealthCheckStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHealthCheckStatusResponse =
      zio.aws.route53.model
        .GetHealthCheckStatusResponse(healthCheckObservations.map { item =>
          item.asEditable
        })
    def healthCheckObservations
        : List[zio.aws.route53.model.HealthCheckObservation.ReadOnly]
    def getHealthCheckObservations: ZIO[Any, Nothing, List[
      zio.aws.route53.model.HealthCheckObservation.ReadOnly
    ]] = ZIO.succeed(healthCheckObservations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse
  ) extends zio.aws.route53.model.GetHealthCheckStatusResponse.ReadOnly {
    override val healthCheckObservations
        : List[zio.aws.route53.model.HealthCheckObservation.ReadOnly] = impl
      .healthCheckObservations()
      .asScala
      .map { item =>
        zio.aws.route53.model.HealthCheckObservation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse
  ): zio.aws.route53.model.GetHealthCheckStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
