package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.QueryLoggingConfigId
import scala.jdk.CollectionConverters.*
final case class GetQueryLoggingConfigRequest(id: QueryLoggingConfigId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest = {
    import GetQueryLoggingConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest
      .builder()
      .id(QueryLoggingConfigId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetQueryLoggingConfigRequest.ReadOnly =
    zio.aws.route53.model.GetQueryLoggingConfigRequest.wrap(buildAwsValue())
}
object GetQueryLoggingConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetQueryLoggingConfigRequest =
      zio.aws.route53.model.GetQueryLoggingConfigRequest(id)
    def id: QueryLoggingConfigId
    def getId: ZIO[Any, Nothing, QueryLoggingConfigId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest
  ) extends zio.aws.route53.model.GetQueryLoggingConfigRequest.ReadOnly {
    override val id: QueryLoggingConfigId =
      zio.aws.route53.model.primitives.QueryLoggingConfigId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest
  ): zio.aws.route53.model.GetQueryLoggingConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
