package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetReusableDelegationSetLimitRequest(
    `type`: zio.aws.route53.model.ReusableDelegationSetLimitType,
    delegationSetId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest = {
    import GetReusableDelegationSetLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest
      .builder()
      .`type`(`type`.unwrap)
      .delegationSetId(ResourceId.unwrap(delegationSetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.GetReusableDelegationSetLimitRequest.ReadOnly =
    zio.aws.route53.model.GetReusableDelegationSetLimitRequest
      .wrap(buildAwsValue())
}
object GetReusableDelegationSetLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetReusableDelegationSetLimitRequest =
      zio.aws.route53.model
        .GetReusableDelegationSetLimitRequest(`type`, delegationSetId)
    def `type`: zio.aws.route53.model.ReusableDelegationSetLimitType
    def delegationSetId: ResourceId
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.route53.model.ReusableDelegationSetLimitType
    ] = ZIO.succeed(`type`)
    def getDelegationSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(delegationSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest
  ) extends zio.aws.route53.model.GetReusableDelegationSetLimitRequest.ReadOnly {
    override val `type`: zio.aws.route53.model.ReusableDelegationSetLimitType =
      zio.aws.route53.model.ReusableDelegationSetLimitType.wrap(impl.`type`())
    override val delegationSetId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.delegationSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest
  ): zio.aws.route53.model.GetReusableDelegationSetLimitRequest.ReadOnly =
    new Wrapper(impl)
}
