package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.UsageCount
import scala.jdk.CollectionConverters.*
final case class GetReusableDelegationSetLimitResponse(
    limit: zio.aws.route53.model.ReusableDelegationSetLimit,
    count: UsageCount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse = {
    import GetReusableDelegationSetLimitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse
      .builder()
      .limit(limit.buildAwsValue())
      .count(UsageCount.unwrap(count): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.GetReusableDelegationSetLimitResponse.ReadOnly =
    zio.aws.route53.model.GetReusableDelegationSetLimitResponse
      .wrap(buildAwsValue())
}
object GetReusableDelegationSetLimitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53.model.GetReusableDelegationSetLimitResponse =
      zio.aws.route53.model
        .GetReusableDelegationSetLimitResponse(limit.asEditable, count)
    def limit: zio.aws.route53.model.ReusableDelegationSetLimit.ReadOnly
    def count: UsageCount
    def getLimit: ZIO[
      Any,
      Nothing,
      zio.aws.route53.model.ReusableDelegationSetLimit.ReadOnly
    ] = ZIO.succeed(limit)
    def getCount: ZIO[Any, Nothing, UsageCount] = ZIO.succeed(count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse
  ) extends zio.aws.route53.model.GetReusableDelegationSetLimitResponse.ReadOnly {
    override val limit
        : zio.aws.route53.model.ReusableDelegationSetLimit.ReadOnly =
      zio.aws.route53.model.ReusableDelegationSetLimit.wrap(impl.limit())
    override val count: UsageCount =
      zio.aws.route53.model.primitives.UsageCount(impl.count())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse
  ): zio.aws.route53.model.GetReusableDelegationSetLimitResponse.ReadOnly =
    new Wrapper(impl)
}
