package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetReusableDelegationSetRequest(id: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest = {
    import GetReusableDelegationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.GetReusableDelegationSetRequest.ReadOnly =
    zio.aws.route53.model.GetReusableDelegationSetRequest.wrap(buildAwsValue())
}
object GetReusableDelegationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetReusableDelegationSetRequest =
      zio.aws.route53.model.GetReusableDelegationSetRequest(id)
    def id: ResourceId
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest
  ) extends zio.aws.route53.model.GetReusableDelegationSetRequest.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest
  ): zio.aws.route53.model.GetReusableDelegationSetRequest.ReadOnly =
    new Wrapper(impl)
}
