package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.TrafficPolicyInstanceId
import scala.jdk.CollectionConverters.*
final case class GetTrafficPolicyInstanceRequest(id: TrafficPolicyInstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest = {
    import GetTrafficPolicyInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest
      .builder()
      .id(TrafficPolicyInstanceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.GetTrafficPolicyInstanceRequest.ReadOnly =
    zio.aws.route53.model.GetTrafficPolicyInstanceRequest.wrap(buildAwsValue())
}
object GetTrafficPolicyInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetTrafficPolicyInstanceRequest =
      zio.aws.route53.model.GetTrafficPolicyInstanceRequest(id)
    def id: TrafficPolicyInstanceId
    def getId: ZIO[Any, Nothing, TrafficPolicyInstanceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest
  ) extends zio.aws.route53.model.GetTrafficPolicyInstanceRequest.ReadOnly {
    override val id: TrafficPolicyInstanceId =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest
  ): zio.aws.route53.model.GetTrafficPolicyInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
