package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{TrafficPolicyVersion, TrafficPolicyId}
import scala.jdk.CollectionConverters.*
final case class GetTrafficPolicyRequest(
    id: TrafficPolicyId,
    version: TrafficPolicyVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest = {
    import GetTrafficPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest
      .builder()
      .id(TrafficPolicyId.unwrap(id): java.lang.String)
      .version(TrafficPolicyVersion.unwrap(version): Integer)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetTrafficPolicyRequest.ReadOnly =
    zio.aws.route53.model.GetTrafficPolicyRequest.wrap(buildAwsValue())
}
object GetTrafficPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetTrafficPolicyRequest =
      zio.aws.route53.model.GetTrafficPolicyRequest(id, version)
    def id: TrafficPolicyId
    def version: TrafficPolicyVersion
    def getId: ZIO[Any, Nothing, TrafficPolicyId] = ZIO.succeed(id)
    def getVersion: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest
  ) extends zio.aws.route53.model.GetTrafficPolicyRequest.ReadOnly {
    override val id: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.id())
    override val version: TrafficPolicyVersion =
      zio.aws.route53.model.primitives.TrafficPolicyVersion(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest
  ): zio.aws.route53.model.GetTrafficPolicyRequest.ReadOnly = new Wrapper(impl)
}
