package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTrafficPolicyResponse(
    trafficPolicy: zio.aws.route53.model.TrafficPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse = {
    import GetTrafficPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse
      .builder()
      .trafficPolicy(trafficPolicy.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetTrafficPolicyResponse.ReadOnly =
    zio.aws.route53.model.GetTrafficPolicyResponse.wrap(buildAwsValue())
}
object GetTrafficPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetTrafficPolicyResponse =
      zio.aws.route53.model.GetTrafficPolicyResponse(trafficPolicy.asEditable)
    def trafficPolicy: zio.aws.route53.model.TrafficPolicy.ReadOnly
    def getTrafficPolicy
        : ZIO[Any, Nothing, zio.aws.route53.model.TrafficPolicy.ReadOnly] =
      ZIO.succeed(trafficPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse
  ) extends zio.aws.route53.model.GetTrafficPolicyResponse.ReadOnly {
    override val trafficPolicy: zio.aws.route53.model.TrafficPolicy.ReadOnly =
      zio.aws.route53.model.TrafficPolicy.wrap(impl.trafficPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse
  ): zio.aws.route53.model.GetTrafficPolicyResponse.ReadOnly = new Wrapper(impl)
}
