package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.IPAddress
import scala.jdk.CollectionConverters.*
final case class HealthCheckObservation(
    region: Option[zio.aws.route53.model.HealthCheckRegion] = None,
    ipAddress: Option[IPAddress] = None,
    statusReport: Option[zio.aws.route53.model.StatusReport] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.HealthCheckObservation = {
    import HealthCheckObservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.HealthCheckObservation
      .builder()
      .optionallyWith(region.map(value => value.unwrap))(_.region)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(statusReport.map(value => value.buildAwsValue()))(
        _.statusReport
      )
      .build()
  }
  def asReadOnly: zio.aws.route53.model.HealthCheckObservation.ReadOnly =
    zio.aws.route53.model.HealthCheckObservation.wrap(buildAwsValue())
}
object HealthCheckObservation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.HealthCheckObservation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.HealthCheckObservation =
      zio.aws.route53.model.HealthCheckObservation(
        region.map(value => value),
        ipAddress.map(value => value),
        statusReport.map(value => value.asEditable)
      )
    def region: Option[zio.aws.route53.model.HealthCheckRegion]
    def ipAddress: Option[IPAddress]
    def statusReport: Option[zio.aws.route53.model.StatusReport.ReadOnly]
    def getRegion: ZIO[Any, AwsError, zio.aws.route53.model.HealthCheckRegion] =
      AwsError.unwrapOptionField("region", region)
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getStatusReport
        : ZIO[Any, AwsError, zio.aws.route53.model.StatusReport.ReadOnly] =
      AwsError.unwrapOptionField("statusReport", statusReport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.HealthCheckObservation
  ) extends zio.aws.route53.model.HealthCheckObservation.ReadOnly {
    override val region: Option[zio.aws.route53.model.HealthCheckRegion] = scala
      .Option(impl.region())
      .map(value => zio.aws.route53.model.HealthCheckRegion.wrap(value))
    override val ipAddress: Option[IPAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.route53.model.primitives.IPAddress(value))
    override val statusReport
        : Option[zio.aws.route53.model.StatusReport.ReadOnly] = scala
      .Option(impl.statusReport())
      .map(value => zio.aws.route53.model.StatusReport.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.HealthCheckObservation
  ): zio.aws.route53.model.HealthCheckObservation.ReadOnly = new Wrapper(impl)
}
