package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  HostedZoneRRSetCount,
  Nonce,
  DNSName,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class HostedZone(
    id: ResourceId,
    name: DNSName,
    callerReference: Nonce,
    config: Option[zio.aws.route53.model.HostedZoneConfig] = None,
    resourceRecordSetCount: Option[HostedZoneRRSetCount] = None,
    linkedService: Option[zio.aws.route53.model.LinkedService] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.HostedZone = {
    import HostedZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.HostedZone
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .name(DNSName.unwrap(name): java.lang.String)
      .callerReference(Nonce.unwrap(callerReference): java.lang.String)
      .optionallyWith(config.map(value => value.buildAwsValue()))(_.config)
      .optionallyWith(
        resourceRecordSetCount.map(value =>
          HostedZoneRRSetCount.unwrap(value): java.lang.Long
        )
      )(_.resourceRecordSetCount)
      .optionallyWith(linkedService.map(value => value.buildAwsValue()))(
        _.linkedService
      )
      .build()
  }
  def asReadOnly: zio.aws.route53.model.HostedZone.ReadOnly =
    zio.aws.route53.model.HostedZone.wrap(buildAwsValue())
}
object HostedZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.HostedZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.HostedZone =
      zio.aws.route53.model.HostedZone(
        id,
        name,
        callerReference,
        config.map(value => value.asEditable),
        resourceRecordSetCount.map(value => value),
        linkedService.map(value => value.asEditable)
      )
    def id: ResourceId
    def name: DNSName
    def callerReference: Nonce
    def config: Option[zio.aws.route53.model.HostedZoneConfig.ReadOnly]
    def resourceRecordSetCount: Option[HostedZoneRRSetCount]
    def linkedService: Option[zio.aws.route53.model.LinkedService.ReadOnly]
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(name)
    def getCallerReference: ZIO[Any, Nothing, Nonce] =
      ZIO.succeed(callerReference)
    def getConfig
        : ZIO[Any, AwsError, zio.aws.route53.model.HostedZoneConfig.ReadOnly] =
      AwsError.unwrapOptionField("config", config)
    def getResourceRecordSetCount: ZIO[Any, AwsError, HostedZoneRRSetCount] =
      AwsError.unwrapOptionField(
        "resourceRecordSetCount",
        resourceRecordSetCount
      )
    def getLinkedService
        : ZIO[Any, AwsError, zio.aws.route53.model.LinkedService.ReadOnly] =
      AwsError.unwrapOptionField("linkedService", linkedService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.HostedZone
  ) extends zio.aws.route53.model.HostedZone.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.id())
    override val name: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.name())
    override val callerReference: Nonce =
      zio.aws.route53.model.primitives.Nonce(impl.callerReference())
    override val config
        : Option[zio.aws.route53.model.HostedZoneConfig.ReadOnly] = scala
      .Option(impl.config())
      .map(value => zio.aws.route53.model.HostedZoneConfig.wrap(value))
    override val resourceRecordSetCount: Option[HostedZoneRRSetCount] = scala
      .Option(impl.resourceRecordSetCount())
      .map(value =>
        zio.aws.route53.model.primitives.HostedZoneRRSetCount(value)
      )
    override val linkedService
        : Option[zio.aws.route53.model.LinkedService.ReadOnly] = scala
      .Option(impl.linkedService())
      .map(value => zio.aws.route53.model.LinkedService.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.HostedZone
  ): zio.aws.route53.model.HostedZone.ReadOnly = new Wrapper(impl)
}
