package zio.aws.route53.model
import scala.jdk.CollectionConverters.*
sealed trait HostedZoneLimitType {
  def unwrap: software.amazon.awssdk.services.route53.model.HostedZoneLimitType
}
object HostedZoneLimitType {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.HostedZoneLimitType
  ): zio.aws.route53.model.HostedZoneLimitType = value match {
    case software.amazon.awssdk.services.route53.model.HostedZoneLimitType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.HostedZoneLimitType.MAX_RRSETS_BY_ZONE =>
      val r = MAX_RRSETS_BY_ZONE
      r
    case software.amazon.awssdk.services.route53.model.HostedZoneLimitType.MAX_VPCS_ASSOCIATED_BY_ZONE =>
      val r = MAX_VPCS_ASSOCIATED_BY_ZONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53.model.HostedZoneLimitType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HostedZoneLimitType =
      software.amazon.awssdk.services.route53.model.HostedZoneLimitType.UNKNOWN_TO_SDK_VERSION
  }
  case object MAX_RRSETS_BY_ZONE
      extends zio.aws.route53.model.HostedZoneLimitType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HostedZoneLimitType =
      software.amazon.awssdk.services.route53.model.HostedZoneLimitType.MAX_RRSETS_BY_ZONE
  }
  case object MAX_VPCS_ASSOCIATED_BY_ZONE
      extends zio.aws.route53.model.HostedZoneLimitType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HostedZoneLimitType =
      software.amazon.awssdk.services.route53.model.HostedZoneLimitType.MAX_VPCS_ASSOCIATED_BY_ZONE
  }
}
