package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{DNSName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class HostedZoneSummary(
    hostedZoneId: ResourceId,
    name: DNSName,
    owner: zio.aws.route53.model.HostedZoneOwner
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.HostedZoneSummary = {
    import HostedZoneSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.HostedZoneSummary
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .name(DNSName.unwrap(name): java.lang.String)
      .owner(owner.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.route53.model.HostedZoneSummary.ReadOnly =
    zio.aws.route53.model.HostedZoneSummary.wrap(buildAwsValue())
}
object HostedZoneSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.HostedZoneSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.HostedZoneSummary =
      zio.aws.route53.model
        .HostedZoneSummary(hostedZoneId, name, owner.asEditable)
    def hostedZoneId: ResourceId
    def name: DNSName
    def owner: zio.aws.route53.model.HostedZoneOwner.ReadOnly
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(name)
    def getOwner
        : ZIO[Any, Nothing, zio.aws.route53.model.HostedZoneOwner.ReadOnly] =
      ZIO.succeed(owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.HostedZoneSummary
  ) extends zio.aws.route53.model.HostedZoneSummary.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val name: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.name())
    override val owner: zio.aws.route53.model.HostedZoneOwner.ReadOnly =
      zio.aws.route53.model.HostedZoneOwner.wrap(impl.owner())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.HostedZoneSummary
  ): zio.aws.route53.model.HostedZoneSummary.ReadOnly = new Wrapper(impl)
}
