package zio.aws.route53.model
import zio.aws.route53.model.primitives.{
  SigningKeyStatusMessage,
  SigningKeyInteger,
  SigningKeyString,
  SigningKeyName,
  SigningKeyTag,
  SigningKeyStatus,
  TimeStamp
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class KeySigningKey(
    name: Option[SigningKeyName] = None,
    kmsArn: Option[SigningKeyString] = None,
    flag: Option[SigningKeyInteger] = None,
    signingAlgorithmMnemonic: Option[SigningKeyString] = None,
    signingAlgorithmType: Option[SigningKeyInteger] = None,
    digestAlgorithmMnemonic: Option[SigningKeyString] = None,
    digestAlgorithmType: Option[SigningKeyInteger] = None,
    keyTag: Option[SigningKeyTag] = None,
    digestValue: Option[SigningKeyString] = None,
    publicKey: Option[SigningKeyString] = None,
    dsRecord: Option[SigningKeyString] = None,
    dnskeyRecord: Option[SigningKeyString] = None,
    status: Option[SigningKeyStatus] = None,
    statusMessage: Option[SigningKeyStatusMessage] = None,
    createdDate: Option[TimeStamp] = None,
    lastModifiedDate: Option[TimeStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.KeySigningKey = {
    import KeySigningKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.KeySigningKey
      .builder()
      .optionallyWith(
        name.map(value => SigningKeyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        kmsArn.map(value => SigningKeyString.unwrap(value): java.lang.String)
      )(_.kmsArn)
      .optionallyWith(
        flag.map(value => SigningKeyInteger.unwrap(value): Integer)
      )(_.flag)
      .optionallyWith(
        signingAlgorithmMnemonic.map(value =>
          SigningKeyString.unwrap(value): java.lang.String
        )
      )(_.signingAlgorithmMnemonic)
      .optionallyWith(
        signingAlgorithmType.map(value =>
          SigningKeyInteger.unwrap(value): Integer
        )
      )(_.signingAlgorithmType)
      .optionallyWith(
        digestAlgorithmMnemonic.map(value =>
          SigningKeyString.unwrap(value): java.lang.String
        )
      )(_.digestAlgorithmMnemonic)
      .optionallyWith(
        digestAlgorithmType.map(value =>
          SigningKeyInteger.unwrap(value): Integer
        )
      )(_.digestAlgorithmType)
      .optionallyWith(
        keyTag.map(value => SigningKeyTag.unwrap(value): Integer)
      )(_.keyTag)
      .optionallyWith(
        digestValue.map(value =>
          SigningKeyString.unwrap(value): java.lang.String
        )
      )(_.digestValue)
      .optionallyWith(
        publicKey.map(value => SigningKeyString.unwrap(value): java.lang.String)
      )(_.publicKey)
      .optionallyWith(
        dsRecord.map(value => SigningKeyString.unwrap(value): java.lang.String)
      )(_.dsRecord)
      .optionallyWith(
        dnskeyRecord.map(value =>
          SigningKeyString.unwrap(value): java.lang.String
        )
      )(_.dnskeyRecord)
      .optionallyWith(
        status.map(value => SigningKeyStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          SigningKeyStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        createdDate.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        lastModifiedDate.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.KeySigningKey.ReadOnly =
    zio.aws.route53.model.KeySigningKey.wrap(buildAwsValue())
}
object KeySigningKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.KeySigningKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.KeySigningKey =
      zio.aws.route53.model.KeySigningKey(
        name.map(value => value),
        kmsArn.map(value => value),
        flag.map(value => value),
        signingAlgorithmMnemonic.map(value => value),
        signingAlgorithmType.map(value => value),
        digestAlgorithmMnemonic.map(value => value),
        digestAlgorithmType.map(value => value),
        keyTag.map(value => value),
        digestValue.map(value => value),
        publicKey.map(value => value),
        dsRecord.map(value => value),
        dnskeyRecord.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        createdDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def name: Option[SigningKeyName]
    def kmsArn: Option[SigningKeyString]
    def flag: Option[SigningKeyInteger]
    def signingAlgorithmMnemonic: Option[SigningKeyString]
    def signingAlgorithmType: Option[SigningKeyInteger]
    def digestAlgorithmMnemonic: Option[SigningKeyString]
    def digestAlgorithmType: Option[SigningKeyInteger]
    def keyTag: Option[SigningKeyTag]
    def digestValue: Option[SigningKeyString]
    def publicKey: Option[SigningKeyString]
    def dsRecord: Option[SigningKeyString]
    def dnskeyRecord: Option[SigningKeyString]
    def status: Option[SigningKeyStatus]
    def statusMessage: Option[SigningKeyStatusMessage]
    def createdDate: Option[TimeStamp]
    def lastModifiedDate: Option[TimeStamp]
    def getName: ZIO[Any, AwsError, SigningKeyName] =
      AwsError.unwrapOptionField("name", name)
    def getKmsArn: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("kmsArn", kmsArn)
    def getFlag: ZIO[Any, AwsError, SigningKeyInteger] =
      AwsError.unwrapOptionField("flag", flag)
    def getSigningAlgorithmMnemonic: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField(
        "signingAlgorithmMnemonic",
        signingAlgorithmMnemonic
      )
    def getSigningAlgorithmType: ZIO[Any, AwsError, SigningKeyInteger] =
      AwsError.unwrapOptionField("signingAlgorithmType", signingAlgorithmType)
    def getDigestAlgorithmMnemonic: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField(
        "digestAlgorithmMnemonic",
        digestAlgorithmMnemonic
      )
    def getDigestAlgorithmType: ZIO[Any, AwsError, SigningKeyInteger] =
      AwsError.unwrapOptionField("digestAlgorithmType", digestAlgorithmType)
    def getKeyTag: ZIO[Any, AwsError, SigningKeyTag] =
      AwsError.unwrapOptionField("keyTag", keyTag)
    def getDigestValue: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("digestValue", digestValue)
    def getPublicKey: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getDsRecord: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("dsRecord", dsRecord)
    def getDnskeyRecord: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("dnskeyRecord", dnskeyRecord)
    def getStatus: ZIO[Any, AwsError, SigningKeyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, SigningKeyStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreatedDate: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getLastModifiedDate: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.KeySigningKey
  ) extends zio.aws.route53.model.KeySigningKey.ReadOnly {
    override val name: Option[SigningKeyName] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53.model.primitives.SigningKeyName(value))
    override val kmsArn: Option[SigningKeyString] = scala
      .Option(impl.kmsArn())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val flag: Option[SigningKeyInteger] = scala
      .Option(impl.flag())
      .map(value => zio.aws.route53.model.primitives.SigningKeyInteger(value))
    override val signingAlgorithmMnemonic: Option[SigningKeyString] = scala
      .Option(impl.signingAlgorithmMnemonic())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val signingAlgorithmType: Option[SigningKeyInteger] = scala
      .Option(impl.signingAlgorithmType())
      .map(value => zio.aws.route53.model.primitives.SigningKeyInteger(value))
    override val digestAlgorithmMnemonic: Option[SigningKeyString] = scala
      .Option(impl.digestAlgorithmMnemonic())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val digestAlgorithmType: Option[SigningKeyInteger] = scala
      .Option(impl.digestAlgorithmType())
      .map(value => zio.aws.route53.model.primitives.SigningKeyInteger(value))
    override val keyTag: Option[SigningKeyTag] = scala
      .Option(impl.keyTag())
      .map(value => zio.aws.route53.model.primitives.SigningKeyTag(value))
    override val digestValue: Option[SigningKeyString] = scala
      .Option(impl.digestValue())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val publicKey: Option[SigningKeyString] = scala
      .Option(impl.publicKey())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val dsRecord: Option[SigningKeyString] = scala
      .Option(impl.dsRecord())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val dnskeyRecord: Option[SigningKeyString] = scala
      .Option(impl.dnskeyRecord())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val status: Option[SigningKeyStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.route53.model.primitives.SigningKeyStatus(value))
    override val statusMessage: Option[SigningKeyStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.route53.model.primitives.SigningKeyStatusMessage(value)
      )
    override val createdDate: Option[TimeStamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.route53.model.primitives.TimeStamp(value))
    override val lastModifiedDate: Option[TimeStamp] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.route53.model.primitives.TimeStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.KeySigningKey
  ): zio.aws.route53.model.KeySigningKey.ReadOnly = new Wrapper(impl)
}
