package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  PageTruncated,
  PageMaxItems,
  GeoLocationCountryCode,
  GeoLocationContinentCode,
  GeoLocationSubdivisionCode
}
import scala.jdk.CollectionConverters.*
final case class ListGeoLocationsResponse(
    geoLocationDetailsList: Iterable[zio.aws.route53.model.GeoLocationDetails],
    isTruncated: PageTruncated,
    nextContinentCode: Option[GeoLocationContinentCode] = None,
    nextCountryCode: Option[GeoLocationCountryCode] = None,
    nextSubdivisionCode: Option[GeoLocationSubdivisionCode] = None,
    maxItems: PageMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse = {
    import ListGeoLocationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse
      .builder()
      .geoLocationDetailsList(geoLocationDetailsList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .isTruncated(PageTruncated.unwrap(isTruncated): java.lang.Boolean)
      .optionallyWith(
        nextContinentCode.map(value =>
          GeoLocationContinentCode.unwrap(value): java.lang.String
        )
      )(_.nextContinentCode)
      .optionallyWith(
        nextCountryCode.map(value =>
          GeoLocationCountryCode.unwrap(value): java.lang.String
        )
      )(_.nextCountryCode)
      .optionallyWith(
        nextSubdivisionCode.map(value =>
          GeoLocationSubdivisionCode.unwrap(value): java.lang.String
        )
      )(_.nextSubdivisionCode)
      .maxItems(PageMaxItems.unwrap(maxItems): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListGeoLocationsResponse.ReadOnly =
    zio.aws.route53.model.ListGeoLocationsResponse.wrap(buildAwsValue())
}
object ListGeoLocationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListGeoLocationsResponse =
      zio.aws.route53.model.ListGeoLocationsResponse(
        geoLocationDetailsList.map { item =>
          item.asEditable
        },
        isTruncated,
        nextContinentCode.map(value => value),
        nextCountryCode.map(value => value),
        nextSubdivisionCode.map(value => value),
        maxItems
      )
    def geoLocationDetailsList
        : List[zio.aws.route53.model.GeoLocationDetails.ReadOnly]
    def isTruncated: PageTruncated
    def nextContinentCode: Option[GeoLocationContinentCode]
    def nextCountryCode: Option[GeoLocationCountryCode]
    def nextSubdivisionCode: Option[GeoLocationSubdivisionCode]
    def maxItems: PageMaxItems
    def getGeoLocationDetailsList: ZIO[Any, Nothing, List[
      zio.aws.route53.model.GeoLocationDetails.ReadOnly
    ]] = ZIO.succeed(geoLocationDetailsList)
    def getIsTruncated: ZIO[Any, Nothing, PageTruncated] =
      ZIO.succeed(isTruncated)
    def getNextContinentCode: ZIO[Any, AwsError, GeoLocationContinentCode] =
      AwsError.unwrapOptionField("nextContinentCode", nextContinentCode)
    def getNextCountryCode: ZIO[Any, AwsError, GeoLocationCountryCode] =
      AwsError.unwrapOptionField("nextCountryCode", nextCountryCode)
    def getNextSubdivisionCode: ZIO[Any, AwsError, GeoLocationSubdivisionCode] =
      AwsError.unwrapOptionField("nextSubdivisionCode", nextSubdivisionCode)
    def getMaxItems: ZIO[Any, Nothing, PageMaxItems] = ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse
  ) extends zio.aws.route53.model.ListGeoLocationsResponse.ReadOnly {
    override val geoLocationDetailsList
        : List[zio.aws.route53.model.GeoLocationDetails.ReadOnly] = impl
      .geoLocationDetailsList()
      .asScala
      .map { item =>
        zio.aws.route53.model.GeoLocationDetails.wrap(item)
      }
      .toList
    override val isTruncated: PageTruncated =
      zio.aws.route53.model.primitives.PageTruncated(impl.isTruncated())
    override val nextContinentCode: Option[GeoLocationContinentCode] = scala
      .Option(impl.nextContinentCode())
      .map(value =>
        zio.aws.route53.model.primitives.GeoLocationContinentCode(value)
      )
    override val nextCountryCode: Option[GeoLocationCountryCode] = scala
      .Option(impl.nextCountryCode())
      .map(value =>
        zio.aws.route53.model.primitives.GeoLocationCountryCode(value)
      )
    override val nextSubdivisionCode: Option[GeoLocationSubdivisionCode] = scala
      .Option(impl.nextSubdivisionCode())
      .map(value =>
        zio.aws.route53.model.primitives.GeoLocationSubdivisionCode(value)
      )
    override val maxItems: PageMaxItems =
      zio.aws.route53.model.primitives.PageMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse
  ): zio.aws.route53.model.ListGeoLocationsResponse.ReadOnly = new Wrapper(impl)
}
