package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{PageMaxItems, ResourceId, DNSName}
import scala.jdk.CollectionConverters.*
final case class ListHostedZonesByNameRequest(
    dnsName: Option[DNSName] = None,
    hostedZoneId: Option[ResourceId] = None,
    maxItems: Option[PageMaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest = {
    import ListHostedZonesByNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest
      .builder()
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        hostedZoneId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.hostedZoneId)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListHostedZonesByNameRequest.ReadOnly =
    zio.aws.route53.model.ListHostedZonesByNameRequest.wrap(buildAwsValue())
}
object ListHostedZonesByNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListHostedZonesByNameRequest =
      zio.aws.route53.model.ListHostedZonesByNameRequest(
        dnsName.map(value => value),
        hostedZoneId.map(value => value),
        maxItems.map(value => value)
      )
    def dnsName: Option[DNSName]
    def hostedZoneId: Option[ResourceId]
    def maxItems: Option[PageMaxItems]
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getHostedZoneId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest
  ) extends zio.aws.route53.model.ListHostedZonesByNameRequest.ReadOnly {
    override val dnsName: Option[DNSName] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val hostedZoneId: Option[ResourceId] = scala
      .Option(impl.hostedZoneId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val maxItems: Option[PageMaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest
  ): zio.aws.route53.model.ListHostedZonesByNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
