package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{PaginationToken, PageMaxItems}
import scala.jdk.CollectionConverters.*
final case class ListHostedZonesByVpcResponse(
    hostedZoneSummaries: Iterable[zio.aws.route53.model.HostedZoneSummary],
    maxItems: PageMaxItems,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcResponse = {
    import ListHostedZonesByVpcResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcResponse
      .builder()
      .hostedZoneSummaries(hostedZoneSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .maxItems(PageMaxItems.unwrap(maxItems): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly =
    zio.aws.route53.model.ListHostedZonesByVpcResponse.wrap(buildAwsValue())
}
object ListHostedZonesByVpcResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListHostedZonesByVpcResponse =
      zio.aws.route53.model.ListHostedZonesByVpcResponse(
        hostedZoneSummaries.map { item =>
          item.asEditable
        },
        maxItems,
        nextToken.map(value => value)
      )
    def hostedZoneSummaries
        : List[zio.aws.route53.model.HostedZoneSummary.ReadOnly]
    def maxItems: PageMaxItems
    def nextToken: Option[PaginationToken]
    def getHostedZoneSummaries: ZIO[Any, Nothing, List[
      zio.aws.route53.model.HostedZoneSummary.ReadOnly
    ]] = ZIO.succeed(hostedZoneSummaries)
    def getMaxItems: ZIO[Any, Nothing, PageMaxItems] = ZIO.succeed(maxItems)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcResponse
  ) extends zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly {
    override val hostedZoneSummaries
        : List[zio.aws.route53.model.HostedZoneSummary.ReadOnly] = impl
      .hostedZoneSummaries()
      .asScala
      .map { item =>
        zio.aws.route53.model.HostedZoneSummary.wrap(item)
      }
      .toList
    override val maxItems: PageMaxItems =
      zio.aws.route53.model.primitives.PageMaxItems(impl.maxItems())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcResponse
  ): zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly = new Wrapper(
    impl
  )
}
