package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{ResourceId, PageMaxItems, PageMarker}
import scala.jdk.CollectionConverters.*
final case class ListHostedZonesRequest(
    marker: Option[PageMarker] = None,
    maxItems: Option[PageMaxItems] = None,
    delegationSetId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListHostedZonesRequest = {
    import ListHostedZonesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListHostedZonesRequest
      .builder()
      .optionallyWith(
        marker.map(value => PageMarker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .optionallyWith(
        delegationSetId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.delegationSetId)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListHostedZonesRequest.ReadOnly =
    zio.aws.route53.model.ListHostedZonesRequest.wrap(buildAwsValue())
}
object ListHostedZonesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListHostedZonesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListHostedZonesRequest =
      zio.aws.route53.model.ListHostedZonesRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        delegationSetId.map(value => value)
      )
    def marker: Option[PageMarker]
    def maxItems: Option[PageMaxItems]
    def delegationSetId: Option[ResourceId]
    def getMarker: ZIO[Any, AwsError, PageMarker] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getDelegationSetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("delegationSetId", delegationSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesRequest
  ) extends zio.aws.route53.model.ListHostedZonesRequest.ReadOnly {
    override val marker: Option[PageMarker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.route53.model.primitives.PageMarker(value))
    override val maxItems: Option[PageMaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
    override val delegationSetId: Option[ResourceId] = scala
      .Option(impl.delegationSetId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesRequest
  ): zio.aws.route53.model.ListHostedZonesRequest.ReadOnly = new Wrapper(impl)
}
