package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  PageTruncated,
  PageMarker
}
import scala.jdk.CollectionConverters.*
final case class ListHostedZonesResponse(
    hostedZones: Iterable[zio.aws.route53.model.HostedZone],
    marker: PageMarker,
    isTruncated: PageTruncated,
    nextMarker: Option[PageMarker] = None,
    maxItems: PageMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListHostedZonesResponse = {
    import ListHostedZonesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListHostedZonesResponse
      .builder()
      .hostedZones(hostedZones.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .marker(PageMarker.unwrap(marker): java.lang.String)
      .isTruncated(PageTruncated.unwrap(isTruncated): java.lang.Boolean)
      .optionallyWith(
        nextMarker.map(value => PageMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .maxItems(PageMaxItems.unwrap(maxItems): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListHostedZonesResponse.ReadOnly =
    zio.aws.route53.model.ListHostedZonesResponse.wrap(buildAwsValue())
}
object ListHostedZonesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListHostedZonesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListHostedZonesResponse =
      zio.aws.route53.model.ListHostedZonesResponse(
        hostedZones.map { item =>
          item.asEditable
        },
        marker,
        isTruncated,
        nextMarker.map(value => value),
        maxItems
      )
    def hostedZones: List[zio.aws.route53.model.HostedZone.ReadOnly]
    def marker: PageMarker
    def isTruncated: PageTruncated
    def nextMarker: Option[PageMarker]
    def maxItems: PageMaxItems
    def getHostedZones
        : ZIO[Any, Nothing, List[zio.aws.route53.model.HostedZone.ReadOnly]] =
      ZIO.succeed(hostedZones)
    def getMarker: ZIO[Any, Nothing, PageMarker] = ZIO.succeed(marker)
    def getIsTruncated: ZIO[Any, Nothing, PageTruncated] =
      ZIO.succeed(isTruncated)
    def getNextMarker: ZIO[Any, AwsError, PageMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getMaxItems: ZIO[Any, Nothing, PageMaxItems] = ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesResponse
  ) extends zio.aws.route53.model.ListHostedZonesResponse.ReadOnly {
    override val hostedZones: List[zio.aws.route53.model.HostedZone.ReadOnly] =
      impl
        .hostedZones()
        .asScala
        .map { item =>
          zio.aws.route53.model.HostedZone.wrap(item)
        }
        .toList
    override val marker: PageMarker =
      zio.aws.route53.model.primitives.PageMarker(impl.marker())
    override val isTruncated: PageTruncated =
      zio.aws.route53.model.primitives.PageTruncated(impl.isTruncated())
    override val nextMarker: Option[PageMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.route53.model.primitives.PageMarker(value))
    override val maxItems: PageMaxItems =
      zio.aws.route53.model.primitives.PageMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesResponse
  ): zio.aws.route53.model.ListHostedZonesResponse.ReadOnly = new Wrapper(impl)
}
