package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  MaxResults,
  PaginationToken,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class ListQueryLoggingConfigsRequest(
    hostedZoneId: Option[ResourceId] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest = {
    import ListQueryLoggingConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest
      .builder()
      .optionallyWith(
        hostedZoneId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.hostedZoneId)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.String)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListQueryLoggingConfigsRequest.ReadOnly =
    zio.aws.route53.model.ListQueryLoggingConfigsRequest.wrap(buildAwsValue())
}
object ListQueryLoggingConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListQueryLoggingConfigsRequest =
      zio.aws.route53.model.ListQueryLoggingConfigsRequest(
        hostedZoneId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def hostedZoneId: Option[ResourceId]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getHostedZoneId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest
  ) extends zio.aws.route53.model.ListQueryLoggingConfigsRequest.ReadOnly {
    override val hostedZoneId: Option[ResourceId] = scala
      .Option(impl.hostedZoneId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest
  ): zio.aws.route53.model.ListQueryLoggingConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
