package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListQueryLoggingConfigsResponse(
    queryLoggingConfigs: Iterable[zio.aws.route53.model.QueryLoggingConfig],
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse = {
    import ListQueryLoggingConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse
      .builder()
      .queryLoggingConfigs(queryLoggingConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListQueryLoggingConfigsResponse.ReadOnly =
    zio.aws.route53.model.ListQueryLoggingConfigsResponse.wrap(buildAwsValue())
}
object ListQueryLoggingConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListQueryLoggingConfigsResponse =
      zio.aws.route53.model.ListQueryLoggingConfigsResponse(
        queryLoggingConfigs.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def queryLoggingConfigs
        : List[zio.aws.route53.model.QueryLoggingConfig.ReadOnly]
    def nextToken: Option[PaginationToken]
    def getQueryLoggingConfigs: ZIO[Any, Nothing, List[
      zio.aws.route53.model.QueryLoggingConfig.ReadOnly
    ]] = ZIO.succeed(queryLoggingConfigs)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse
  ) extends zio.aws.route53.model.ListQueryLoggingConfigsResponse.ReadOnly {
    override val queryLoggingConfigs
        : List[zio.aws.route53.model.QueryLoggingConfig.ReadOnly] = impl
      .queryLoggingConfigs()
      .asScala
      .map { item =>
        zio.aws.route53.model.QueryLoggingConfig.wrap(item)
      }
      .toList
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse
  ): zio.aws.route53.model.ListQueryLoggingConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
