package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  ResourceRecordSetIdentifier,
  DNSName,
  PageTruncated
}
import scala.jdk.CollectionConverters.*
final case class ListResourceRecordSetsResponse(
    resourceRecordSets: Iterable[zio.aws.route53.model.ResourceRecordSet],
    isTruncated: PageTruncated,
    nextRecordName: Option[DNSName] = None,
    nextRecordType: Option[zio.aws.route53.model.RRType] = None,
    nextRecordIdentifier: Option[ResourceRecordSetIdentifier] = None,
    maxItems: PageMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse = {
    import ListResourceRecordSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse
      .builder()
      .resourceRecordSets(resourceRecordSets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .isTruncated(PageTruncated.unwrap(isTruncated): java.lang.Boolean)
      .optionallyWith(
        nextRecordName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.nextRecordName)
      .optionallyWith(nextRecordType.map(value => value.unwrap))(
        _.nextRecordType
      )
      .optionallyWith(
        nextRecordIdentifier.map(value =>
          ResourceRecordSetIdentifier.unwrap(value): java.lang.String
        )
      )(_.nextRecordIdentifier)
      .maxItems(PageMaxItems.unwrap(maxItems): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListResourceRecordSetsResponse.ReadOnly =
    zio.aws.route53.model.ListResourceRecordSetsResponse.wrap(buildAwsValue())
}
object ListResourceRecordSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListResourceRecordSetsResponse =
      zio.aws.route53.model.ListResourceRecordSetsResponse(
        resourceRecordSets.map { item =>
          item.asEditable
        },
        isTruncated,
        nextRecordName.map(value => value),
        nextRecordType.map(value => value),
        nextRecordIdentifier.map(value => value),
        maxItems
      )
    def resourceRecordSets
        : List[zio.aws.route53.model.ResourceRecordSet.ReadOnly]
    def isTruncated: PageTruncated
    def nextRecordName: Option[DNSName]
    def nextRecordType: Option[zio.aws.route53.model.RRType]
    def nextRecordIdentifier: Option[ResourceRecordSetIdentifier]
    def maxItems: PageMaxItems
    def getResourceRecordSets: ZIO[Any, Nothing, List[
      zio.aws.route53.model.ResourceRecordSet.ReadOnly
    ]] = ZIO.succeed(resourceRecordSets)
    def getIsTruncated: ZIO[Any, Nothing, PageTruncated] =
      ZIO.succeed(isTruncated)
    def getNextRecordName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("nextRecordName", nextRecordName)
    def getNextRecordType: ZIO[Any, AwsError, zio.aws.route53.model.RRType] =
      AwsError.unwrapOptionField("nextRecordType", nextRecordType)
    def getNextRecordIdentifier
        : ZIO[Any, AwsError, ResourceRecordSetIdentifier] =
      AwsError.unwrapOptionField("nextRecordIdentifier", nextRecordIdentifier)
    def getMaxItems: ZIO[Any, Nothing, PageMaxItems] = ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse
  ) extends zio.aws.route53.model.ListResourceRecordSetsResponse.ReadOnly {
    override val resourceRecordSets
        : List[zio.aws.route53.model.ResourceRecordSet.ReadOnly] = impl
      .resourceRecordSets()
      .asScala
      .map { item =>
        zio.aws.route53.model.ResourceRecordSet.wrap(item)
      }
      .toList
    override val isTruncated: PageTruncated =
      zio.aws.route53.model.primitives.PageTruncated(impl.isTruncated())
    override val nextRecordName: Option[DNSName] = scala
      .Option(impl.nextRecordName())
      .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val nextRecordType: Option[zio.aws.route53.model.RRType] = scala
      .Option(impl.nextRecordType())
      .map(value => zio.aws.route53.model.RRType.wrap(value))
    override val nextRecordIdentifier: Option[ResourceRecordSetIdentifier] =
      scala
        .Option(impl.nextRecordIdentifier())
        .map(value =>
          zio.aws.route53.model.primitives.ResourceRecordSetIdentifier(value)
        )
    override val maxItems: PageMaxItems =
      zio.aws.route53.model.primitives.PageMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse
  ): zio.aws.route53.model.ListResourceRecordSetsResponse.ReadOnly =
    new Wrapper(impl)
}
