package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{PageMaxItems, PageMarker}
import scala.jdk.CollectionConverters.*
final case class ListReusableDelegationSetsRequest(
    marker: Option[PageMarker] = None,
    maxItems: Option[PageMaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest = {
    import ListReusableDelegationSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest
      .builder()
      .optionallyWith(
        marker.map(value => PageMarker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListReusableDelegationSetsRequest.ReadOnly =
    zio.aws.route53.model.ListReusableDelegationSetsRequest
      .wrap(buildAwsValue())
}
object ListReusableDelegationSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListReusableDelegationSetsRequest =
      zio.aws.route53.model.ListReusableDelegationSetsRequest(
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def marker: Option[PageMarker]
    def maxItems: Option[PageMaxItems]
    def getMarker: ZIO[Any, AwsError, PageMarker] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest
  ) extends zio.aws.route53.model.ListReusableDelegationSetsRequest.ReadOnly {
    override val marker: Option[PageMarker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.route53.model.primitives.PageMarker(value))
    override val maxItems: Option[PageMaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest
  ): zio.aws.route53.model.ListReusableDelegationSetsRequest.ReadOnly =
    new Wrapper(impl)
}
