package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.TagResourceId
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    resourceType: zio.aws.route53.model.TagResourceType,
    resourceId: TagResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceId(TagResourceId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.route53.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTagsForResourceRequest =
      zio.aws.route53.model.ListTagsForResourceRequest(resourceType, resourceId)
    def resourceType: zio.aws.route53.model.TagResourceType
    def resourceId: TagResourceId
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.route53.model.TagResourceType] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, TagResourceId] =
      ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest
  ) extends zio.aws.route53.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceType: zio.aws.route53.model.TagResourceType =
      zio.aws.route53.model.TagResourceType.wrap(impl.resourceType())
    override val resourceId: TagResourceId =
      zio.aws.route53.model.primitives.TagResourceId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest
  ): zio.aws.route53.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
