package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.TagResourceId
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourcesRequest(
    resourceType: zio.aws.route53.model.TagResourceType,
    resourceIds: Iterable[TagResourceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest = {
    import ListTagsForResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceIds(resourceIds.map { item =>
        TagResourceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListTagsForResourcesRequest.ReadOnly =
    zio.aws.route53.model.ListTagsForResourcesRequest.wrap(buildAwsValue())
}
object ListTagsForResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTagsForResourcesRequest =
      zio.aws.route53.model
        .ListTagsForResourcesRequest(resourceType, resourceIds)
    def resourceType: zio.aws.route53.model.TagResourceType
    def resourceIds: List[TagResourceId]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.route53.model.TagResourceType] =
      ZIO.succeed(resourceType)
    def getResourceIds: ZIO[Any, Nothing, List[TagResourceId]] =
      ZIO.succeed(resourceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest
  ) extends zio.aws.route53.model.ListTagsForResourcesRequest.ReadOnly {
    override val resourceType: zio.aws.route53.model.TagResourceType =
      zio.aws.route53.model.TagResourceType.wrap(impl.resourceType())
    override val resourceIds: List[TagResourceId] = impl
      .resourceIds()
      .asScala
      .map { item =>
        zio.aws.route53.model.primitives.TagResourceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest
  ): zio.aws.route53.model.ListTagsForResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
