package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourcesResponse(
    resourceTagSets: Iterable[zio.aws.route53.model.ResourceTagSet]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse = {
    import ListTagsForResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse
      .builder()
      .resourceTagSets(resourceTagSets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListTagsForResourcesResponse.ReadOnly =
    zio.aws.route53.model.ListTagsForResourcesResponse.wrap(buildAwsValue())
}
object ListTagsForResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTagsForResourcesResponse =
      zio.aws.route53.model.ListTagsForResourcesResponse(resourceTagSets.map {
        item =>
          item.asEditable
      })
    def resourceTagSets: List[zio.aws.route53.model.ResourceTagSet.ReadOnly]
    def getResourceTagSets: ZIO[Any, Nothing, List[
      zio.aws.route53.model.ResourceTagSet.ReadOnly
    ]] = ZIO.succeed(resourceTagSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse
  ) extends zio.aws.route53.model.ListTagsForResourcesResponse.ReadOnly {
    override val resourceTagSets
        : List[zio.aws.route53.model.ResourceTagSet.ReadOnly] = impl
      .resourceTagSets()
      .asScala
      .map { item =>
        zio.aws.route53.model.ResourceTagSet.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse
  ): zio.aws.route53.model.ListTagsForResourcesResponse.ReadOnly = new Wrapper(
    impl
  )
}
