package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  TrafficPolicyId,
  PageTruncated
}
import scala.jdk.CollectionConverters.*
final case class ListTrafficPoliciesResponse(
    trafficPolicySummaries: Iterable[
      zio.aws.route53.model.TrafficPolicySummary
    ],
    isTruncated: PageTruncated,
    trafficPolicyIdMarker: TrafficPolicyId,
    maxItems: PageMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse = {
    import ListTrafficPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse
      .builder()
      .trafficPolicySummaries(trafficPolicySummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .isTruncated(PageTruncated.unwrap(isTruncated): java.lang.Boolean)
      .trafficPolicyIdMarker(
        TrafficPolicyId.unwrap(trafficPolicyIdMarker): java.lang.String
      )
      .maxItems(PageMaxItems.unwrap(maxItems): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListTrafficPoliciesResponse.ReadOnly =
    zio.aws.route53.model.ListTrafficPoliciesResponse.wrap(buildAwsValue())
}
object ListTrafficPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTrafficPoliciesResponse =
      zio.aws.route53.model.ListTrafficPoliciesResponse(
        trafficPolicySummaries.map { item =>
          item.asEditable
        },
        isTruncated,
        trafficPolicyIdMarker,
        maxItems
      )
    def trafficPolicySummaries
        : List[zio.aws.route53.model.TrafficPolicySummary.ReadOnly]
    def isTruncated: PageTruncated
    def trafficPolicyIdMarker: TrafficPolicyId
    def maxItems: PageMaxItems
    def getTrafficPolicySummaries: ZIO[Any, Nothing, List[
      zio.aws.route53.model.TrafficPolicySummary.ReadOnly
    ]] = ZIO.succeed(trafficPolicySummaries)
    def getIsTruncated: ZIO[Any, Nothing, PageTruncated] =
      ZIO.succeed(isTruncated)
    def getTrafficPolicyIdMarker: ZIO[Any, Nothing, TrafficPolicyId] =
      ZIO.succeed(trafficPolicyIdMarker)
    def getMaxItems: ZIO[Any, Nothing, PageMaxItems] = ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse
  ) extends zio.aws.route53.model.ListTrafficPoliciesResponse.ReadOnly {
    override val trafficPolicySummaries
        : List[zio.aws.route53.model.TrafficPolicySummary.ReadOnly] = impl
      .trafficPolicySummaries()
      .asScala
      .map { item =>
        zio.aws.route53.model.TrafficPolicySummary.wrap(item)
      }
      .toList
    override val isTruncated: PageTruncated =
      zio.aws.route53.model.primitives.PageTruncated(impl.isTruncated())
    override val trafficPolicyIdMarker: TrafficPolicyId =
      zio.aws.route53.model.primitives
        .TrafficPolicyId(impl.trafficPolicyIdMarker())
    override val maxItems: PageMaxItems =
      zio.aws.route53.model.primitives.PageMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse
  ): zio.aws.route53.model.ListTrafficPoliciesResponse.ReadOnly = new Wrapper(
    impl
  )
}
