package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{PageMaxItems, DNSName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class ListTrafficPolicyInstancesByHostedZoneRequest(
    hostedZoneId: ResourceId,
    trafficPolicyInstanceNameMarker: Option[DNSName] = None,
    trafficPolicyInstanceTypeMarker: Option[zio.aws.route53.model.RRType] =
      None,
    maxItems: Option[PageMaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest = {
    import ListTrafficPolicyInstancesByHostedZoneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .optionallyWith(
        trafficPolicyInstanceNameMarker.map(value =>
          DNSName.unwrap(value): java.lang.String
        )
      )(_.trafficPolicyInstanceNameMarker)
      .optionallyWith(
        trafficPolicyInstanceTypeMarker.map(value => value.unwrap)
      )(_.trafficPolicyInstanceTypeMarker)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest.ReadOnly =
    zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest
      .wrap(buildAwsValue())
}
object ListTrafficPolicyInstancesByHostedZoneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest =
      zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest(
        hostedZoneId,
        trafficPolicyInstanceNameMarker.map(value => value),
        trafficPolicyInstanceTypeMarker.map(value => value),
        maxItems.map(value => value)
      )
    def hostedZoneId: ResourceId
    def trafficPolicyInstanceNameMarker: Option[DNSName]
    def trafficPolicyInstanceTypeMarker: Option[zio.aws.route53.model.RRType]
    def maxItems: Option[PageMaxItems]
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getTrafficPolicyInstanceNameMarker: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField(
        "trafficPolicyInstanceNameMarker",
        trafficPolicyInstanceNameMarker
      )
    def getTrafficPolicyInstanceTypeMarker
        : ZIO[Any, AwsError, zio.aws.route53.model.RRType] =
      AwsError.unwrapOptionField(
        "trafficPolicyInstanceTypeMarker",
        trafficPolicyInstanceTypeMarker
      )
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest
  ) extends zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val trafficPolicyInstanceNameMarker: Option[DNSName] = scala
      .Option(impl.trafficPolicyInstanceNameMarker())
      .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val trafficPolicyInstanceTypeMarker
        : Option[zio.aws.route53.model.RRType] = scala
      .Option(impl.trafficPolicyInstanceTypeMarker())
      .map(value => zio.aws.route53.model.RRType.wrap(value))
    override val maxItems: Option[PageMaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest
  ): zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest.ReadOnly =
    new Wrapper(impl)
}
