package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  DNSName,
  PageMaxItems,
  TrafficPolicyId,
  TrafficPolicyVersion,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class ListTrafficPolicyInstancesByPolicyRequest(
    trafficPolicyId: TrafficPolicyId,
    trafficPolicyVersion: TrafficPolicyVersion,
    hostedZoneIdMarker: Option[ResourceId] = None,
    trafficPolicyInstanceNameMarker: Option[DNSName] = None,
    trafficPolicyInstanceTypeMarker: Option[zio.aws.route53.model.RRType] =
      None,
    maxItems: Option[PageMaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest = {
    import ListTrafficPolicyInstancesByPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest
      .builder()
      .trafficPolicyId(
        TrafficPolicyId.unwrap(trafficPolicyId): java.lang.String
      )
      .trafficPolicyVersion(
        TrafficPolicyVersion.unwrap(trafficPolicyVersion): Integer
      )
      .optionallyWith(
        hostedZoneIdMarker.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.hostedZoneIdMarker)
      .optionallyWith(
        trafficPolicyInstanceNameMarker.map(value =>
          DNSName.unwrap(value): java.lang.String
        )
      )(_.trafficPolicyInstanceNameMarker)
      .optionallyWith(
        trafficPolicyInstanceTypeMarker.map(value => value.unwrap)
      )(_.trafficPolicyInstanceTypeMarker)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyRequest.ReadOnly =
    zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyRequest
      .wrap(buildAwsValue())
}
object ListTrafficPolicyInstancesByPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyRequest =
      zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyRequest(
        trafficPolicyId,
        trafficPolicyVersion,
        hostedZoneIdMarker.map(value => value),
        trafficPolicyInstanceNameMarker.map(value => value),
        trafficPolicyInstanceTypeMarker.map(value => value),
        maxItems.map(value => value)
      )
    def trafficPolicyId: TrafficPolicyId
    def trafficPolicyVersion: TrafficPolicyVersion
    def hostedZoneIdMarker: Option[ResourceId]
    def trafficPolicyInstanceNameMarker: Option[DNSName]
    def trafficPolicyInstanceTypeMarker: Option[zio.aws.route53.model.RRType]
    def maxItems: Option[PageMaxItems]
    def getTrafficPolicyId: ZIO[Any, Nothing, TrafficPolicyId] =
      ZIO.succeed(trafficPolicyId)
    def getTrafficPolicyVersion: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(trafficPolicyVersion)
    def getHostedZoneIdMarker: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneIdMarker", hostedZoneIdMarker)
    def getTrafficPolicyInstanceNameMarker: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField(
        "trafficPolicyInstanceNameMarker",
        trafficPolicyInstanceNameMarker
      )
    def getTrafficPolicyInstanceTypeMarker
        : ZIO[Any, AwsError, zio.aws.route53.model.RRType] =
      AwsError.unwrapOptionField(
        "trafficPolicyInstanceTypeMarker",
        trafficPolicyInstanceTypeMarker
      )
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest
  ) extends zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyRequest.ReadOnly {
    override val trafficPolicyId: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.trafficPolicyId())
    override val trafficPolicyVersion: TrafficPolicyVersion =
      zio.aws.route53.model.primitives
        .TrafficPolicyVersion(impl.trafficPolicyVersion())
    override val hostedZoneIdMarker: Option[ResourceId] = scala
      .Option(impl.hostedZoneIdMarker())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val trafficPolicyInstanceNameMarker: Option[DNSName] = scala
      .Option(impl.trafficPolicyInstanceNameMarker())
      .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val trafficPolicyInstanceTypeMarker
        : Option[zio.aws.route53.model.RRType] = scala
      .Option(impl.trafficPolicyInstanceTypeMarker())
      .map(value => zio.aws.route53.model.RRType.wrap(value))
    override val maxItems: Option[PageMaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest
  ): zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
