package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{PaginationToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class ListVpcAssociationAuthorizationsResponse(
    hostedZoneId: ResourceId,
    nextToken: Option[PaginationToken] = None,
    vpCs: Iterable[zio.aws.route53.model.VPC]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse = {
    import ListVpcAssociationAuthorizationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .vpCs(vpCs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly =
    zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse
      .wrap(buildAwsValue())
}
object ListVpcAssociationAuthorizationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse =
      zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse(
        hostedZoneId,
        nextToken.map(value => value),
        vpCs.map { item =>
          item.asEditable
        }
      )
    def hostedZoneId: ResourceId
    def nextToken: Option[PaginationToken]
    def vpCs: List[zio.aws.route53.model.VPC.ReadOnly]
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpCs: ZIO[Any, Nothing, List[zio.aws.route53.model.VPC.ReadOnly]] =
      ZIO.succeed(vpCs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse
  ) extends zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
    override val vpCs: List[zio.aws.route53.model.VPC.ReadOnly] = impl
      .vpCs()
      .asScala
      .map { item =>
        zio.aws.route53.model.VPC.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse
  ): zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly =
    new Wrapper(impl)
}
