package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  CloudWatchLogsLogGroupArn,
  ResourceId,
  QueryLoggingConfigId
}
import scala.jdk.CollectionConverters.*
final case class QueryLoggingConfig(
    id: QueryLoggingConfigId,
    hostedZoneId: ResourceId,
    cloudWatchLogsLogGroupArn: CloudWatchLogsLogGroupArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.QueryLoggingConfig = {
    import QueryLoggingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.QueryLoggingConfig
      .builder()
      .id(QueryLoggingConfigId.unwrap(id): java.lang.String)
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .cloudWatchLogsLogGroupArn(
        CloudWatchLogsLogGroupArn.unwrap(
          cloudWatchLogsLogGroupArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.route53.model.QueryLoggingConfig.ReadOnly =
    zio.aws.route53.model.QueryLoggingConfig.wrap(buildAwsValue())
}
object QueryLoggingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.QueryLoggingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.QueryLoggingConfig =
      zio.aws.route53.model
        .QueryLoggingConfig(id, hostedZoneId, cloudWatchLogsLogGroupArn)
    def id: QueryLoggingConfigId
    def hostedZoneId: ResourceId
    def cloudWatchLogsLogGroupArn: CloudWatchLogsLogGroupArn
    def getId: ZIO[Any, Nothing, QueryLoggingConfigId] = ZIO.succeed(id)
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getCloudWatchLogsLogGroupArn
        : ZIO[Any, Nothing, CloudWatchLogsLogGroupArn] =
      ZIO.succeed(cloudWatchLogsLogGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.QueryLoggingConfig
  ) extends zio.aws.route53.model.QueryLoggingConfig.ReadOnly {
    override val id: QueryLoggingConfigId =
      zio.aws.route53.model.primitives.QueryLoggingConfigId(impl.id())
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val cloudWatchLogsLogGroupArn: CloudWatchLogsLogGroupArn =
      zio.aws.route53.model.primitives
        .CloudWatchLogsLogGroupArn(impl.cloudWatchLogsLogGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.QueryLoggingConfig
  ): zio.aws.route53.model.QueryLoggingConfig.ReadOnly = new Wrapper(impl)
}
