package zio.aws.route53.model
import scala.jdk.CollectionConverters.*
sealed trait RRType {
  def unwrap: software.amazon.awssdk.services.route53.model.RRType
}
object RRType {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.RRType
  ): zio.aws.route53.model.RRType = value match {
    case software.amazon.awssdk.services.route53.model.RRType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.RRType.SOA =>
      val r = SOA
      r
    case software.amazon.awssdk.services.route53.model.RRType.A =>
      val r = A
      r
    case software.amazon.awssdk.services.route53.model.RRType.TXT =>
      val r = TXT
      r
    case software.amazon.awssdk.services.route53.model.RRType.NS =>
      val r = NS
      r
    case software.amazon.awssdk.services.route53.model.RRType.CNAME =>
      val r = CNAME
      r
    case software.amazon.awssdk.services.route53.model.RRType.MX =>
      val r = MX
      r
    case software.amazon.awssdk.services.route53.model.RRType.NAPTR =>
      val r = NAPTR
      r
    case software.amazon.awssdk.services.route53.model.RRType.PTR =>
      val r = PTR
      r
    case software.amazon.awssdk.services.route53.model.RRType.SRV =>
      val r = SRV
      r
    case software.amazon.awssdk.services.route53.model.RRType.SPF =>
      val r = SPF
      r
    case software.amazon.awssdk.services.route53.model.RRType.AAAA =>
      val r = AAAA
      r
    case software.amazon.awssdk.services.route53.model.RRType.CAA =>
      val r = CAA
      r
    case software.amazon.awssdk.services.route53.model.RRType.DS =>
      val r = DS
      r
  }
  case object unknownToSdkVersion extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.UNKNOWN_TO_SDK_VERSION
  }
  case object SOA extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.SOA
  }
  case object A extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.A
  }
  case object TXT extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.TXT
  }
  case object NS extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.NS
  }
  case object CNAME extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.CNAME
  }
  case object MX extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.MX
  }
  case object NAPTR extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.NAPTR
  }
  case object PTR extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.PTR
  }
  case object SRV extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.SRV
  }
  case object SPF extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.SPF
  }
  case object AAAA extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.AAAA
  }
  case object CAA extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.CAA
  }
  case object DS extends zio.aws.route53.model.RRType {
    override def unwrap: software.amazon.awssdk.services.route53.model.RRType =
      software.amazon.awssdk.services.route53.model.RRType.DS
  }
}
