package zio.aws.route53.model
import scala.jdk.CollectionConverters.*
sealed trait ResettableElementName {
  def unwrap
      : software.amazon.awssdk.services.route53.model.ResettableElementName
}
object ResettableElementName {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.ResettableElementName
  ): zio.aws.route53.model.ResettableElementName = value match {
    case software.amazon.awssdk.services.route53.model.ResettableElementName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.ResettableElementName.FULLY_QUALIFIED_DOMAIN_NAME =>
      val r = FullyQualifiedDomainName
      r
    case software.amazon.awssdk.services.route53.model.ResettableElementName.REGIONS =>
      val r = Regions
      r
    case software.amazon.awssdk.services.route53.model.ResettableElementName.RESOURCE_PATH =>
      val r = ResourcePath
      r
    case software.amazon.awssdk.services.route53.model.ResettableElementName.CHILD_HEALTH_CHECKS =>
      val r = ChildHealthChecks
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53.model.ResettableElementName {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ResettableElementName =
      software.amazon.awssdk.services.route53.model.ResettableElementName.UNKNOWN_TO_SDK_VERSION
  }
  case object FullyQualifiedDomainName
      extends zio.aws.route53.model.ResettableElementName {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ResettableElementName =
      software.amazon.awssdk.services.route53.model.ResettableElementName.FULLY_QUALIFIED_DOMAIN_NAME
  }
  case object Regions extends zio.aws.route53.model.ResettableElementName {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ResettableElementName =
      software.amazon.awssdk.services.route53.model.ResettableElementName.REGIONS
  }
  case object ResourcePath extends zio.aws.route53.model.ResettableElementName {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ResettableElementName =
      software.amazon.awssdk.services.route53.model.ResettableElementName.RESOURCE_PATH
  }
  case object ChildHealthChecks
      extends zio.aws.route53.model.ResettableElementName {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ResettableElementName =
      software.amazon.awssdk.services.route53.model.ResettableElementName.CHILD_HEALTH_CHECKS
  }
}
