package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  ResourceRecordSetMultiValueAnswer,
  DNSName,
  TTL,
  ResourceRecordSetWeight,
  ResourceRecordSetIdentifier,
  HealthCheckId,
  TrafficPolicyInstanceId
}
import scala.jdk.CollectionConverters.*
final case class ResourceRecordSet(
    name: DNSName,
    `type`: zio.aws.route53.model.RRType,
    setIdentifier: Option[ResourceRecordSetIdentifier] = None,
    weight: Option[ResourceRecordSetWeight] = None,
    region: Option[zio.aws.route53.model.ResourceRecordSetRegion] = None,
    geoLocation: Option[zio.aws.route53.model.GeoLocation] = None,
    failover: Option[zio.aws.route53.model.ResourceRecordSetFailover] = None,
    multiValueAnswer: Option[ResourceRecordSetMultiValueAnswer] = None,
    ttl: Option[TTL] = None,
    resourceRecords: Option[Iterable[zio.aws.route53.model.ResourceRecord]] =
      None,
    aliasTarget: Option[zio.aws.route53.model.AliasTarget] = None,
    healthCheckId: Option[HealthCheckId] = None,
    trafficPolicyInstanceId: Option[TrafficPolicyInstanceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ResourceRecordSet = {
    import ResourceRecordSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ResourceRecordSet
      .builder()
      .name(DNSName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        setIdentifier.map(value =>
          ResourceRecordSetIdentifier.unwrap(value): java.lang.String
        )
      )(_.setIdentifier)
      .optionallyWith(
        weight.map(value =>
          ResourceRecordSetWeight.unwrap(value): java.lang.Long
        )
      )(_.weight)
      .optionallyWith(region.map(value => value.unwrap))(_.region)
      .optionallyWith(geoLocation.map(value => value.buildAwsValue()))(
        _.geoLocation
      )
      .optionallyWith(failover.map(value => value.unwrap))(_.failover)
      .optionallyWith(
        multiValueAnswer.map(value =>
          ResourceRecordSetMultiValueAnswer.unwrap(value): java.lang.Boolean
        )
      )(_.multiValueAnswer)
      .optionallyWith(ttl.map(value => TTL.unwrap(value): java.lang.Long))(
        _.ttl
      )
      .optionallyWith(
        resourceRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRecords)
      .optionallyWith(aliasTarget.map(value => value.buildAwsValue()))(
        _.aliasTarget
      )
      .optionallyWith(
        healthCheckId.map(value =>
          HealthCheckId.unwrap(value): java.lang.String
        )
      )(_.healthCheckId)
      .optionallyWith(
        trafficPolicyInstanceId.map(value =>
          TrafficPolicyInstanceId.unwrap(value): java.lang.String
        )
      )(_.trafficPolicyInstanceId)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ResourceRecordSet.ReadOnly =
    zio.aws.route53.model.ResourceRecordSet.wrap(buildAwsValue())
}
object ResourceRecordSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ResourceRecordSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ResourceRecordSet =
      zio.aws.route53.model.ResourceRecordSet(
        name,
        `type`,
        setIdentifier.map(value => value),
        weight.map(value => value),
        region.map(value => value),
        geoLocation.map(value => value.asEditable),
        failover.map(value => value),
        multiValueAnswer.map(value => value),
        ttl.map(value => value),
        resourceRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aliasTarget.map(value => value.asEditable),
        healthCheckId.map(value => value),
        trafficPolicyInstanceId.map(value => value)
      )
    def name: DNSName
    def `type`: zio.aws.route53.model.RRType
    def setIdentifier: Option[ResourceRecordSetIdentifier]
    def weight: Option[ResourceRecordSetWeight]
    def region: Option[zio.aws.route53.model.ResourceRecordSetRegion]
    def geoLocation: Option[zio.aws.route53.model.GeoLocation.ReadOnly]
    def failover: Option[zio.aws.route53.model.ResourceRecordSetFailover]
    def multiValueAnswer: Option[ResourceRecordSetMultiValueAnswer]
    def ttl: Option[TTL]
    def resourceRecords
        : Option[List[zio.aws.route53.model.ResourceRecord.ReadOnly]]
    def aliasTarget: Option[zio.aws.route53.model.AliasTarget.ReadOnly]
    def healthCheckId: Option[HealthCheckId]
    def trafficPolicyInstanceId: Option[TrafficPolicyInstanceId]
    def getName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.route53.model.RRType] =
      ZIO.succeed(`type`)
    def getSetIdentifier: ZIO[Any, AwsError, ResourceRecordSetIdentifier] =
      AwsError.unwrapOptionField("setIdentifier", setIdentifier)
    def getWeight: ZIO[Any, AwsError, ResourceRecordSetWeight] =
      AwsError.unwrapOptionField("weight", weight)
    def getRegion
        : ZIO[Any, AwsError, zio.aws.route53.model.ResourceRecordSetRegion] =
      AwsError.unwrapOptionField("region", region)
    def getGeoLocation
        : ZIO[Any, AwsError, zio.aws.route53.model.GeoLocation.ReadOnly] =
      AwsError.unwrapOptionField("geoLocation", geoLocation)
    def getFailover
        : ZIO[Any, AwsError, zio.aws.route53.model.ResourceRecordSetFailover] =
      AwsError.unwrapOptionField("failover", failover)
    def getMultiValueAnswer
        : ZIO[Any, AwsError, ResourceRecordSetMultiValueAnswer] =
      AwsError.unwrapOptionField("multiValueAnswer", multiValueAnswer)
    def getTtl: ZIO[Any, AwsError, TTL] = AwsError.unwrapOptionField("ttl", ttl)
    def getResourceRecords: ZIO[Any, AwsError, List[
      zio.aws.route53.model.ResourceRecord.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceRecords", resourceRecords)
    def getAliasTarget
        : ZIO[Any, AwsError, zio.aws.route53.model.AliasTarget.ReadOnly] =
      AwsError.unwrapOptionField("aliasTarget", aliasTarget)
    def getHealthCheckId: ZIO[Any, AwsError, HealthCheckId] =
      AwsError.unwrapOptionField("healthCheckId", healthCheckId)
    def getTrafficPolicyInstanceId
        : ZIO[Any, AwsError, TrafficPolicyInstanceId] = AwsError
      .unwrapOptionField("trafficPolicyInstanceId", trafficPolicyInstanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ResourceRecordSet
  ) extends zio.aws.route53.model.ResourceRecordSet.ReadOnly {
    override val name: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.name())
    override val `type`: zio.aws.route53.model.RRType =
      zio.aws.route53.model.RRType.wrap(impl.`type`())
    override val setIdentifier: Option[ResourceRecordSetIdentifier] = scala
      .Option(impl.setIdentifier())
      .map(value =>
        zio.aws.route53.model.primitives.ResourceRecordSetIdentifier(value)
      )
    override val weight: Option[ResourceRecordSetWeight] = scala
      .Option(impl.weight())
      .map(value =>
        zio.aws.route53.model.primitives.ResourceRecordSetWeight(value)
      )
    override val region: Option[zio.aws.route53.model.ResourceRecordSetRegion] =
      scala
        .Option(impl.region())
        .map(value => zio.aws.route53.model.ResourceRecordSetRegion.wrap(value))
    override val geoLocation
        : Option[zio.aws.route53.model.GeoLocation.ReadOnly] = scala
      .Option(impl.geoLocation())
      .map(value => zio.aws.route53.model.GeoLocation.wrap(value))
    override val failover
        : Option[zio.aws.route53.model.ResourceRecordSetFailover] = scala
      .Option(impl.failover())
      .map(value => zio.aws.route53.model.ResourceRecordSetFailover.wrap(value))
    override val multiValueAnswer: Option[ResourceRecordSetMultiValueAnswer] =
      scala
        .Option(impl.multiValueAnswer())
        .map(value =>
          zio.aws.route53.model.primitives
            .ResourceRecordSetMultiValueAnswer(value)
        )
    override val ttl: Option[TTL] = scala
      .Option(impl.ttl())
      .map(value => zio.aws.route53.model.primitives.TTL(value))
    override val resourceRecords
        : Option[List[zio.aws.route53.model.ResourceRecord.ReadOnly]] = scala
      .Option(impl.resourceRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53.model.ResourceRecord.wrap(item)
        }.toList
      )
    override val aliasTarget
        : Option[zio.aws.route53.model.AliasTarget.ReadOnly] = scala
      .Option(impl.aliasTarget())
      .map(value => zio.aws.route53.model.AliasTarget.wrap(value))
    override val healthCheckId: Option[HealthCheckId] = scala
      .Option(impl.healthCheckId())
      .map(value => zio.aws.route53.model.primitives.HealthCheckId(value))
    override val trafficPolicyInstanceId: Option[TrafficPolicyInstanceId] =
      scala
        .Option(impl.trafficPolicyInstanceId())
        .map(value =>
          zio.aws.route53.model.primitives.TrafficPolicyInstanceId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ResourceRecordSet
  ): zio.aws.route53.model.ResourceRecordSet.ReadOnly = new Wrapper(impl)
}
