package zio.aws.route53.model
import scala.jdk.CollectionConverters.*
sealed trait Statistic {
  def unwrap: software.amazon.awssdk.services.route53.model.Statistic
}
object Statistic {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.Statistic
  ): zio.aws.route53.model.Statistic = value match {
    case software.amazon.awssdk.services.route53.model.Statistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.Statistic.AVERAGE =>
      val r = Average
      r
    case software.amazon.awssdk.services.route53.model.Statistic.SUM =>
      val r = Sum
      r
    case software.amazon.awssdk.services.route53.model.Statistic.SAMPLE_COUNT =>
      val r = SampleCount
      r
    case software.amazon.awssdk.services.route53.model.Statistic.MAXIMUM =>
      val r = Maximum
      r
    case software.amazon.awssdk.services.route53.model.Statistic.MINIMUM =>
      val r = Minimum
      r
  }
  case object unknownToSdkVersion extends zio.aws.route53.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.Statistic =
      software.amazon.awssdk.services.route53.model.Statistic.UNKNOWN_TO_SDK_VERSION
  }
  case object Average extends zio.aws.route53.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.Statistic =
      software.amazon.awssdk.services.route53.model.Statistic.AVERAGE
  }
  case object Sum extends zio.aws.route53.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.Statistic =
      software.amazon.awssdk.services.route53.model.Statistic.SUM
  }
  case object SampleCount extends zio.aws.route53.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.Statistic =
      software.amazon.awssdk.services.route53.model.Statistic.SAMPLE_COUNT
  }
  case object Maximum extends zio.aws.route53.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.Statistic =
      software.amazon.awssdk.services.route53.model.Statistic.MAXIMUM
  }
  case object Minimum extends zio.aws.route53.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.Statistic =
      software.amazon.awssdk.services.route53.model.Statistic.MINIMUM
  }
}
